# -*- coding: utf-8 -*-
"""
Created on Mon Aug 17 17:34:45 2015

Wallis et al 1989b

steady flow conditions
Tr: residence time = t_mean - tau
t_mean = travel time, t2 -t1
tau = time delay = t2' - t1'
ti' = first arrival time at location ti
delta =  discrete-time quivalent of time delay, tau that is nearest integer value tau/delta_time
deta_time = the time step or sampling interval


C(x2, t) = -alpha C(x2, t - 1) + (1+alpha) C (x1, t-delta)
alpha = - exp(-delta_time/Tr)

Dispersive fraction Df = Tr/t_mean = (t_mean - tau)/t_mean

@author: ci1vcs
"""


def ADZ(Co, tau, tbar,ADomain):
    
    import math
    import numpy as np
    
#==============================================================================
# TEST PARAMETERS
#     to = 0
#     tmax = 255
#     deltat = 5.
#     time = np.arange(to, tmax, deltat)    
#     xo = 1
#     x_max = 3
#     deltax = 1.
#     X = np.arange(xo, x_max, deltax)
#     tau = 75.
#     tbar = 100.
#     Co = [0,0,0.2,1.3, 8.5, 13, 10.5, 7, 4, 1.7, 0.5, 0,0,0]
#==============================================================================
   
    time_values = ADomain.Time.InclusiveRange()
    time = np.array((time_values),float) 
    deltat = ADomain.Time.Step     
    X_values = ADomain.X.InclusiveRange()
    X = X_values
    
    y_length = ADomain.Y.NumberOfSteps()    
    
    C = np.zeros((len(X), y_length, len(time)), float)    
    
    for t in np.arange(0,len(Co)):
        C[0,:,t] = Co[t]
    
    T = tbar - tau 
    alpha = - math.exp(-deltat/T)
    delta = np.int(tau/deltat)
    
    for t in np.arange(0,len(time)-1):
        for i in np.arange(0,len(X)-1):            
             #if index is negative, concentration in river is background C, make it zero for now             
            b = t-delta
            
            if b < 0:
                b = 0
            else:
                C[i+1,:,t] = - alpha * C[i+1,:,t-1] + (1+alpha) * C[i,:,b]

           
    return C